var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
//
// Copyright (C) Microsoft. All rights reserved.
//
//--------
// External CommonMerged references.  These are included explicitly in the csproj
// as the CommonMerged.d.ts is generated at build-time.
// If we reference them here, TSC 1.8.10 includes the source in the merged JS file
// which is not what we want.
//--------
// <reference path="../../Common/Util/keyCodes.ts" />
// <reference path="../../Common/Controls/templateControl.ts" />
// <reference path="../../Common/Util/formattingHelpers.ts" />
// <reference path="../../Common/controls/componentModel.ts" />
// <reference path="../../Common/Profiler/SnapshotSummary.ts" />
//--------
/// <reference path="../../../../../common/script/Hub/plugin.redirect.d.ts" />
/// <reference path="SummaryView.ts" />
var MemoryProfiler;
(function (MemoryProfiler) {
    "use strict";
    var SnapshotTileViewModel = (function (_super) {
        __extends(SnapshotTileViewModel, _super);
        function SnapshotTileViewModel(summary, snapshotSummaryCollection) {
            _super.call(this);
            this._summary = summary;
            this._snapshotSummaryCollection = snapshotSummaryCollection;
        }
        Object.defineProperty(SnapshotTileViewModel.prototype, "summaryData", {
            get: function () { return this._summary; },
            set: function (v) {
                this._summary = v;
                this.raisePropertyChanged("summaryData");
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "timeTaken", {
            get: function () {
                var date = new Date(this._summary.snapshot.timestamp);
                return "(" + date.toLocaleTimeString() + ")";
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "nativeSize", {
            get: function () {
                return this.summaryData.nativeTotalSize;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "nativeSizeDisplayString", {
            get: function () {
                return MemoryProfiler.Common.FormattingHelpers.getPrettyPrintSize(this.nativeSize);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "nativeCount", {
            get: function () {
                return this.summaryData.nativeTotalCount;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "nativeCountDisplayString", {
            get: function () {
                return Microsoft.Plugin.Resources.getString("NativeCount", MemoryProfiler.Common.FormattingHelpers.getDecimalLocaleString(this.nativeCount, true));
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "nativeSizeDiff", {
            get: function () {
                var previousSnapshot = this.getPreviousSnapshot();
                if (previousSnapshot) {
                    return this._summary.nativeTotalSize - previousSnapshot.nativeTotalSize;
                }
                return 0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "nativeSizeDiffDisplayString", {
            get: function () {
                if (this.nativeSizeDiff === 0) {
                    return Microsoft.Plugin.Resources.getString("NoDiff");
                }
                else {
                    return MemoryProfiler.Common.FormattingHelpers.getPrettyPrintSize(this.nativeSizeDiff, true);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "nativeCountDiff", {
            get: function () {
                var previousSnapshot = this.getPreviousSnapshot();
                if (previousSnapshot) {
                    return this._summary.nativeTotalCount - previousSnapshot.nativeTotalCount;
                }
                return 0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "nativeCountDiffDisplayString", {
            get: function () {
                if (this.nativeCountDiff === 0) {
                    return Microsoft.Plugin.Resources.getString("NoDiff");
                }
                else {
                    return MemoryProfiler.Common.FormattingHelpers.getDecimalLocaleString(this.nativeCountDiff, true, true);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "managedSize", {
            get: function () {
                return this.summaryData.managedTotalSize;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "managedSizeDisplayString", {
            get: function () {
                return MemoryProfiler.Common.FormattingHelpers.getPrettyPrintSize(this.managedSize);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "managedCount", {
            get: function () {
                return this.summaryData.managedTotalCount;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "managedCountDisplayString", {
            get: function () {
                return Microsoft.Plugin.Resources.getString("ManagedCount", MemoryProfiler.Common.FormattingHelpers.getDecimalLocaleString(this.managedCount, true));
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "managedSizeDiff", {
            get: function () {
                var previousSnapshot = this.getPreviousSnapshot();
                if (previousSnapshot) {
                    return this._summary.managedTotalSize - previousSnapshot.managedTotalSize;
                }
                return 0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "managedSizeDiffDisplayString", {
            get: function () {
                if (this.managedSizeDiff === 0) {
                    return Microsoft.Plugin.Resources.getString("NoDiff");
                }
                else {
                    return MemoryProfiler.Common.FormattingHelpers.getPrettyPrintSize(this.managedSizeDiff, true);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "managedCountDiff", {
            get: function () {
                var previousSnapshot = this.getPreviousSnapshot();
                if (previousSnapshot) {
                    return this._summary.managedTotalCount - previousSnapshot.managedTotalCount;
                }
                return 0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "managedCountDiffDisplayString", {
            get: function () {
                if (this.managedCountDiff === 0) {
                    return Microsoft.Plugin.Resources.getString("NoDiff");
                }
                else {
                    return MemoryProfiler.Common.FormattingHelpers.getDecimalLocaleString(this.managedCountDiff, true, true);
                }
            },
            enumerable: true,
            configurable: true
        });
        SnapshotTileViewModel.prototype.getComparableSnapshots = function () {
            var result = [];
            for (var i = 0; i < this._snapshotSummaryCollection.length; i++) {
                var summary = this._snapshotSummaryCollection.getItem(i);
                if (summary.id !== this._summary.id) {
                    result.push(summary);
                }
            }
            return result;
        };
        Object.defineProperty(SnapshotTileViewModel.prototype, "isFirstSnapshot", {
            get: function () {
                return this.getPreviousSnapshot() === null;
            },
            enumerable: true,
            configurable: true
        });
        // Note we assume id === array index
        SnapshotTileViewModel.prototype.getPreviousSnapshot = function () {
            var previousId = this._summary.id - 1;
            if (previousId >= 0 && previousId < this._snapshotSummaryCollection.length) {
                return this._snapshotSummaryCollection.getItem(previousId);
            }
            return null;
        };
        return SnapshotTileViewModel;
    }(MemoryProfiler.Common.Controls.ObservableViewModel));
    MemoryProfiler.SnapshotTileViewModel = SnapshotTileViewModel;
    var SnapshotTileView = (function (_super) {
        __extends(SnapshotTileView, _super);
        function SnapshotTileView(controller, model) {
            _super.call(this, "SnapshotTileTemplate");
            this._controller = controller;
            this._model = model;
            this._controller.model.registerPropertyChanged(this);
            this._model.registerPropertyChanged(this);
            this._tileContextMenuItems = [];
            this._snapshotTile = this.findElement("snapshotTile");
            this._tileHeader = this.findElement("snapshotTileHeader");
            this.findElement("snapshotTileTitle").innerText = Microsoft.Plugin.Resources.getString("SnapshotNumber", this._model.summaryData.id + 1);
            this._screenshotHolder = this.findElement("snapshotTileImage");
            this._screenshotNotAvailableMessage = this.findElement("screenshotNotAvailableMessage");
            if (this._model.summaryData.snapshot.screenshotFile) {
                this._screenshotHolder.src = this._model.summaryData.snapshot.screenshotFile;
                this._screenshotNotAvailableMessage.style.display = "none";
            }
            this.findElement("snapshotTakenDate").innerText = this._model.timeTaken;
            this._screenshotNotAvailableMessage.innerText = Microsoft.Plugin.Resources.getString("ScreenshotNotAvailable");
            this._snapshotLoadingProgress = this.findElement("loadingSnapshotProgress");
            this.populateContextMenu();
            this.updateUI();
        }
        SnapshotTileView.prototype.updateUI = function () {
            this.populateWarningsSection();
            this.populateSummaryLinks();
            this.updateSnapshotDisplayType();
            this.updateLoadingProgress();
        };
        SnapshotTileView.prototype.populateWarningsSection = function () {
            this.findElement("snapshotTileWarnings").style.visibility = "hidden";
        };
        SnapshotTileView.prototype.onPropertyChanged = function (propertyName) {
            switch (propertyName) {
                case "snapshotDisplayType":
                    this.updateSnapshotDisplayType();
                    break;
                case "summaryData":
                    this.updateUI();
                    break;
            }
        };
        SnapshotTileView.prototype.updateLoadingProgress = function () {
            if (this._model.summaryData.isProcessingCompleted) {
                this._screenshotHolder.style.visibility = "";
                this._screenshotNotAvailableMessage.style.visibility = "";
                this._snapshotLoadingProgress.style.visibility = "hidden";
                this.updateSnapshotDisplayType();
            }
            else {
                this._managedSummaryDiv.style.visibility = "hidden";
                this._nativeSummaryDiv.style.visibility = "hidden";
                this._screenshotHolder.style.visibility = "hidden";
                this._screenshotNotAvailableMessage.style.visibility = "hidden";
                this._snapshotLoadingProgress.style.visibility = "";
            }
        };
        SnapshotTileView.prototype.updateSnapshotDisplayType = function () {
            if (this._controller.model.snapshotDisplayType === MemoryProfiler.SnapshotDisplayType.managed) {
                this._managedSummaryDiv.style.visibility = this._model.summaryData.isProcessingCompleted ? "" : "hidden";
                this._nativeSummaryDiv.style.visibility = "hidden";
            }
            else if (this._controller.model.snapshotDisplayType === MemoryProfiler.SnapshotDisplayType.native) {
                this._managedSummaryDiv.style.visibility = "hidden";
                this._nativeSummaryDiv.style.visibility = this._model.summaryData.isProcessingCompleted ? "" : "hidden";
            }
        };
        SnapshotTileView.prototype.onCollectionChanged = function (eventArgs) {
            if (eventArgs.action === MemoryProfiler.Common.Controls.NotifyCollectionChangedAction.Add) {
                var newSummary = eventArgs.newItems[0];
                if (this._model.summaryData.id !== newSummary.id) {
                    var contextMenuItem = {
                        callback: this.onDiffToSnapshot.bind(this, newSummary.id),
                        disabled: this.shouldDisableCompareMenu.bind(this),
                        label: Microsoft.Plugin.Resources.getString("SnapshotNumber", newSummary.id + 1),
                        type: Microsoft.Plugin.ContextMenu.MenuItemType.command
                    };
                    this._tileContextMenuItems.push(contextMenuItem);
                }
                this.createContextMenu();
            }
        };
        SnapshotTileView.prototype.createContextMenu = function () {
            if (this._tileContextMenu) {
                this._tileContextMenu.detach(this._snapshotTile);
            }
            if (this._tileContextMenuItems.length > 0) {
                var compareToMenuItem = {
                    callback: function () { },
                    label: Microsoft.Plugin.Resources.getString("CompareTo"),
                    disabled: this.shouldDisableCompareMenu.bind(this),
                    submenu: this._tileContextMenuItems,
                    type: Microsoft.Plugin.ContextMenu.MenuItemType.command
                };
                this._tileContextMenu = Microsoft.Plugin.ContextMenu.create([compareToMenuItem]);
                this._tileContextMenu.attach(this._snapshotTile);
            }
        };
        SnapshotTileView.prototype.shouldDisableCompareMenu = function () {
            return this._controller.model.restoringSnapshots;
        };
        SnapshotTileView.prototype.populateContextMenu = function () {
            var comparableSnapshots = this._model.getComparableSnapshots();
            for (var i = 0; i < comparableSnapshots.length; i++) {
                var comparable = comparableSnapshots[i];
                var contextMenuItem = {
                    callback: this.onDiffToSnapshot.bind(this, comparable.id),
                    disabled: this.shouldDisableCompareMenu.bind(this),
                    label: Microsoft.Plugin.Resources.getString("SnapshotNumber", comparable.id + 1),
                    type: Microsoft.Plugin.ContextMenu.MenuItemType.command
                };
                this._tileContextMenuItems.push(contextMenuItem);
            }
            this.createContextMenu();
        };
        SnapshotTileView.prototype.populateSummaryLinks = function () {
            // Managed data
            this._managedSummaryDiv = this.findElement("managedSummaryData");
            var managedCountLink = this.findElement("managedCountLink");
            var managedSizeLink = this.findElement("managedSizeLink");
            var managedCountDiffLink = this.findElement("managedCountDiffLink");
            var managedCountDiffIndicatorIcon = this.findElement("managedCountDiffIndicatorIcon");
            var managedSizeDiffLink = this.findElement("managedSizeDiffLink");
            var managedSizeDiffIndicatorIcon = this.findElement("managedSizeDiffIndicatorIcon");
            managedCountLink.innerText = this._model.managedCountDisplayString;
            managedSizeLink.innerText = this._model.managedSizeDisplayString;
            managedSizeLink.setAttribute("data-plugin-vs-tooltip", Microsoft.Plugin.Resources.getString("ManagedSizeLinkTooltip"));
            managedCountLink.setAttribute("data-plugin-vs-tooltip", Microsoft.Plugin.Resources.getString("ManagedCountLinkTooltip"));
            managedSizeLink.onclick = this.onManagedSizeClick.bind(this);
            managedCountLink.onclick = this.onManagedCountClick.bind(this);
            if (!this._model.isFirstSnapshot) {
                managedSizeDiffLink.onclick = this.onManagedSizeDiffClick.bind(this);
                managedCountDiffLink.onclick = this.onManagedCountDiffClick.bind(this);
            }
            this.populateDiffLinks(managedSizeDiffLink, managedSizeDiffIndicatorIcon, this._model.managedSizeDiff, this._model.managedSizeDiffDisplayString, Microsoft.Plugin.Resources.getString("ManagedSizeDiffLinkTooltip"));
            this.populateDiffLinks(managedCountDiffLink, managedCountDiffIndicatorIcon, this._model.managedCountDiff, this._model.managedCountDiffDisplayString, Microsoft.Plugin.Resources.getString("ManagedCountDiffLinkTooltip"));
            // Native data
            this._nativeSummaryDiv = this.findElement("nativeSummaryData");
            var nativeCountLink = this.findElement("nativeCountLink");
            var nativeSizeLink = this.findElement("nativeSizeLink");
            var nativeCountDiffLink = this.findElement("nativeCountDiffLink");
            var nativeCountDiffIndicatorIcon = this.findElement("nativeCountDiffIndicatorIcon");
            var nativeSizeDiffLink = this.findElement("nativeSizeDiffLink");
            var nativeSizeDiffIndicatorIcon = this.findElement("nativeSizeDiffIndicatorIcon");
            nativeCountLink.innerText = this._model.nativeCountDisplayString;
            nativeSizeLink.innerText = this._model.nativeSizeDisplayString;
            nativeCountLink.setAttribute("data-plugin-vs-tooltip", Microsoft.Plugin.Resources.getString("NativeCountLinkTooltip"));
            nativeSizeLink.setAttribute("data-plugin-vs-tooltip", Microsoft.Plugin.Resources.getString("NativeSizeLinkTooltip"));
            nativeSizeLink.onclick = this.onNativeSizeClick.bind(this);
            nativeCountLink.onclick = this.onNativeCountClick.bind(this);
            if (!this._model.isFirstSnapshot) {
                nativeSizeDiffLink.onclick = this.onNativeSizeDiffClick.bind(this);
                nativeCountDiffLink.onclick = this.onNativeCountDiffClick.bind(this);
            }
            this.populateDiffLinks(nativeSizeDiffLink, nativeSizeDiffIndicatorIcon, this._model.nativeSizeDiff, this._model.nativeSizeDiffDisplayString, Microsoft.Plugin.Resources.getString("NativeSizeDiffLinkTooltip"));
            this.populateDiffLinks(nativeCountDiffLink, nativeCountDiffIndicatorIcon, this._model.nativeCountDiff, this._model.nativeCountDiffDisplayString, Microsoft.Plugin.Resources.getString("NativeCountDiffLinkTooltip"));
            var links = this.findElementsByClassName("BPT-FileLink");
            for (var linkIndex = 0; linkIndex < links.length; linkIndex++) {
                var linkElement = links[linkIndex];
                linkElement.onkeydown = this.onLinkElementKeyDown.bind(linkElement);
            }
        };
        SnapshotTileView.prototype.onLinkElementKeyDown = function (e) {
            if ((e.keyCode === MemoryProfiler.Common.KeyCodes.ENTER || e.keyCode === MemoryProfiler.Common.KeyCodes.SPACE) && !e.ctrlKey && !e.altKey && !e.shiftKey) {
                e.srcElement.click();
            }
        };
        SnapshotTileView.prototype.populateDiffLinks = function (element, iconElement, delta, deltaDisplayString, deltaTooltip) {
            if (!this._model.isFirstSnapshot) {
                element.innerText = deltaDisplayString;
                element.setAttribute("data-plugin-vs-tooltip", deltaTooltip);
                if (delta > 0) {
                    iconElement.classList.add("increaseIcon");
                }
                else if (delta < 0) {
                    iconElement.classList.add("decreaseIcon");
                }
            }
            else {
                element.classList.remove("BPT-FileLink");
                element.classList.add("baselineText");
                element.innerText = Microsoft.Plugin.Resources.getString("Baseline");
                element.tabIndex = -1;
            }
        };
        SnapshotTileView.prototype.onManagedSizeClick = function (e) {
            this._controller.openManagedSizeDetails(this._model.summaryData.id);
        };
        SnapshotTileView.prototype.onManagedCountClick = function (e) {
            this._controller.openManagedCountDetails(this._model.summaryData.id);
        };
        SnapshotTileView.prototype.onManagedSizeDiffClick = function (e) {
            this._controller.openManagedSizeDiffDetails(this._model.summaryData.id);
        };
        SnapshotTileView.prototype.onManagedCountDiffClick = function (e, target) {
            this._controller.openManagedCountDiffDetails(this._model.summaryData.id);
        };
        SnapshotTileView.prototype.onNativeSizeClick = function (e) {
            this._controller.openNativeSizeDetails(this._model.summaryData.id);
        };
        SnapshotTileView.prototype.onNativeCountClick = function (e) {
            this._controller.openNativeCountDetails(this._model.summaryData.id);
        };
        SnapshotTileView.prototype.onNativeSizeDiffClick = function (e) {
            this._controller.openNativeSizeDiffDetails(this._model.summaryData.id);
        };
        SnapshotTileView.prototype.onNativeCountDiffClick = function (e, target) {
            this._controller.openNativeCountDiffDetails(this._model.summaryData.id);
        };
        SnapshotTileView.prototype.onDiffToSnapshot = function (id) {
            if (this._controller.model.snapshotDisplayType == MemoryProfiler.SnapshotDisplayType.managed) {
                this._controller.openManagedSnapshotDiffDetails(this._model.summaryData.id, id);
            }
            else {
                this._controller.openNativeSnapshotDiffDetails(this._model.summaryData.id, id);
            }
        };
        return SnapshotTileView;
    }(MemoryProfiler.Common.Controls.TemplateControl));
    MemoryProfiler.SnapshotTileView = SnapshotTileView;
})(MemoryProfiler || (MemoryProfiler = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
//--------
// External CommonMerged references.  These are included explicitly in the csproj
// as the CommonMerged.d.ts is generated at build-time.
// If we reference them here, TSC 1.8.10 includes the source in the merged JS file
// which is not what we want.
//--------
// <reference path="../../common/controls/componentModel.ts" />
// <reference path="../../common/controls/templateControl.ts" />
// <reference path="../../common/util/errorFormatter.ts" />
// <reference path="../../common/Profiler/MemoryProfilerViewHost.ts" />
// <reference path="../../common/Profiler/Snapshot.ts" />
// <reference path="../../common/Profiler/SnapshotSummary.ts" />
// <reference path="../../common/Profiler/SnapshotEngine.ts" />
// <reference path="../../common/Profiler/SummaryEngine.ts" />
// <reference path="../../common/Profiler/SummaryAgent.ts" />
// <reference path="../../common/Profiler/ClrSnapshotAgent.ts" />
// <reference path="../../common/Profiler/ScreenshotSnapshotAgent.ts" />
// <reference path="../../common/Profiler/NativeSummaryAgent.ts" />
// <reference path="../../common/Profiler/ManagedSummaryAgent.ts" />
// <reference path="../../common/Profiler/FeedbackConstants.ts" />
//--------
/// <reference path="snapshotTileView.ts" />
/// <reference path="snapshotHeapTypeToggle.ts" />
var Common = MemoryProfiler.Common;
var MemoryProfiler;
(function (MemoryProfiler) {
    "use strict";
    var SummaryViewController = (function () {
        function SummaryViewController(sessionInfo) {
            this._pendingSnapshots = [];
            this._summaryAgents = [];
            MemoryProfiler.Common.MemoryProfilerViewHost.startCodeMarker(MemoryProfiler.Common.CodeMarkerValues.perfMP_ViewLoadStart, MemoryProfiler.Common.CodeMarkerValues.perfMP_ViewLoadEnd);
            this.model = new SummaryViewModel();
            this.view = new SummaryView(this, this.model);
            // DiagHub uses the documentSessionId as the subdomain for ScriptedControls it creates. Since our tool creates details view
            // on its own it needs to know the documentSessionId of the active session so that Daytona would not create a new ScriptedBox
            // Process to run the new control on.
            this._loadDataWarehousePromise = Microsoft.VisualStudio.DiagnosticsHub.DataWarehouse.loadDataWarehouse();
            this._loadDataWarehousePromise.then(function (dataWareHouse) {
                MemoryProfiler.Common.MemoryProfilerViewHost.session.setScriptedContextId(dataWareHouse.getConfiguration().sessionId);
            });
            if (sessionInfo.snapshots.length === 0) {
                this.model.warningMessage = Microsoft.Plugin.Resources.getString("NoSnapshotsTakenWarning");
                ;
                MemoryProfiler.Common.MemoryProfilerViewHost.endCodeMarker(MemoryProfiler.Common.CodeMarkerValues.perfMP_ViewLoadStart);
                return;
            }
            this.loadExistingSnapshots(sessionInfo);
            // Determine what heaps we're supporting.  If supporting managed + native, we need a toggle-bar.
            // Until we hook up User Settings, we only know if target is managed(+native), or just native
            // Once we have User Settings, we'll have a 3rd option: managed-only
            if (sessionInfo.targetRuntime === MemoryProfiler.Common.Extensions.TargetRuntime.mixed) {
                this.view.initializeToggleBar();
            }
            else if (sessionInfo.targetRuntime === MemoryProfiler.Common.Extensions.TargetRuntime.native) {
                // We default to MANAGED unless we're only showing native.
                this.model.snapshotDisplayType = MemoryProfiler.SnapshotDisplayType.native;
            }
        }
        SummaryViewController.prototype.loadExistingSnapshots = function (sessioninfo) {
            var _this = this;
            var snapshots = sessioninfo.snapshots;
            var snapshotAgents = [];
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logBeginLoadSnapshots();
            snapshotAgents.push(new MemoryProfiler.Common.ScreenshotSnapshotAgent());
            if (sessioninfo.targetRuntime !== MemoryProfiler.Common.Extensions.TargetRuntime.native) {
                snapshotAgents.push(new MemoryProfiler.Common.ClrSnapshotAgent());
                this._summaryAgents.push(new MemoryProfiler.Common.ManagedSummaryAgent());
            }
            if (sessioninfo.targetRuntime !== MemoryProfiler.Common.Extensions.TargetRuntime.managed) {
                this._summaryAgents.push(new MemoryProfiler.Common.NativeSummaryAgent(this._loadDataWarehousePromise));
            }
            this.model.restoringSnapshots = true;
            this._pendingSnapshots = [];
            for (var i = 0; i < snapshots.length; i++) {
                var restoreEngine = new MemoryProfiler.Common.SnapshotRestoreEngine(i, snapshotAgents, snapshots[i]);
                restoreEngine.restore(function (snapshot) {
                    _this._pendingSnapshots.push(snapshot);
                    _this.model.snapshotSummaryCollection.add(new MemoryProfiler.Common.SnapshotSummary(snapshot));
                });
            }
            // OK, restoration complete.  That should have been the quick & easy part.
            // Initialize each summary agent in parallel
            MemoryProfiler.Common.MemoryProfilerViewHost.session.getSessionStartupTime().then(function (sessionStartTime) {
                var promises = [];
                _this._summaryAgents.forEach(function (agent) {
                    promises.push(agent.initializeAnalyzerData(sessionStartTime, _this._pendingSnapshots));
                });
                return Microsoft.Plugin.Promise.join(promises);
            }).done(function () {
                // Now, we kick off analysis by reversing the queue and popping of the first snapshot to tackle
                _this._pendingSnapshots.reverse();
                _this.processNextSnapshotSummary();
            });
        };
        SummaryViewController.prototype.openManagedSizeDetails = function (snapshotId) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.OpenManagedHeapViewBySize, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Control, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
            this.viewSnapshot(snapshotId, "ManagedHeap", "RetainedSize");
        };
        SummaryViewController.prototype.openManagedCountDetails = function (snapshotId) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.OpenManagedHeapViewByCount, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Control, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
            this.viewSnapshot(snapshotId, "ManagedHeap", "Count");
        };
        SummaryViewController.prototype.openManagedSizeDiffDetails = function (snapshotId) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.OpenDiffManagedHeapViewBySize, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Control, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
            this.compareSnapshots(snapshotId, snapshotId - 1, "ManagedHeap", "RetainedSizeDiff");
        };
        SummaryViewController.prototype.openManagedCountDiffDetails = function (snapshotId) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.OpenDiffManagedHeapViewByCount, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Control, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
            this.compareSnapshots(snapshotId, snapshotId - 1, "ManagedHeap", "CountDiff");
        };
        SummaryViewController.prototype.openManagedSnapshotDiffDetails = function (snapshotId1, snapshotId2) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.OpenDiffManagedHeapView, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Menu, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
            this.compareSnapshots(Math.max(snapshotId1, snapshotId2), Math.min(snapshotId1, snapshotId2), "ManagedHeap", "RetainedSizeDiff");
        };
        SummaryViewController.prototype.openNativeSizeDetails = function (snapshotId) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.OpenNativeHeapViewBySize, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Control, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
            this.viewSnapshot(snapshotId, "NativeHeap", "OutstandingSize");
        };
        SummaryViewController.prototype.openNativeCountDetails = function (snapshotId) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.OpenNativeHeapViewByCount, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Control, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
            this.viewSnapshot(snapshotId, "NativeHeap", "OutstandingCount");
        };
        SummaryViewController.prototype.openNativeSizeDiffDetails = function (snapshotId) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.OpenDiffNativeHeapViewBySize, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Control, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
            this.compareSnapshots(snapshotId, snapshotId - 1, "NativeHeap", "OutstandingSizeDiff");
        };
        SummaryViewController.prototype.openNativeCountDiffDetails = function (snapshotId) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.OpenDiffNativeHeapViewByCount, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Control, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
            this.compareSnapshots(snapshotId, snapshotId - 1, "NativeHeap", "OutstandingCountDiff");
        };
        SummaryViewController.prototype.openNativeSnapshotDiffDetails = function (snapshotId1, snapshotId2) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.OpenDiffNativeHeapView, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Menu, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
            this.compareSnapshots(Math.max(snapshotId1, snapshotId2), Math.min(snapshotId1, snapshotId2), "NativeHeap", "OutstandingSizeDiff");
        };
        SummaryViewController.prototype.viewSnapshot = function (snapshotId, target, sortProperty) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.openSnapshotDetails(snapshotId, target, sortProperty);
        };
        SummaryViewController.prototype.compareSnapshots = function (lastSnapshotId, firstSnapshotId, target, sortProperty) {
            MemoryProfiler.Common.MemoryProfilerViewHost.session.openSnapshotDiff(firstSnapshotId, lastSnapshotId, target, sortProperty);
        };
        SummaryViewController.prototype.reset = function () {
            this.model.snapshotSummaryCollection.clear();
            MemoryProfiler.Common.MemoryProfilerViewHost.onIdle();
        };
        SummaryViewController.prototype.processNextSnapshotSummary = function () {
            if (this._pendingSnapshots.length == 0) {
                this.summaryProcessCleanup();
            }
            else {
                var snapshot = this._pendingSnapshots.pop();
                this._summaryEngine = new MemoryProfiler.Common.SummaryEngine(snapshot, this._summaryAgents);
                this._summaryEngine.processSummary().done(this.onSummaryProcessComplete.bind(this), this.onSummaryProcessError.bind(this), this.onSummaryProcessProgress.bind(this));
            }
        };
        SummaryViewController.prototype.cancelSummaryProcessing = function () {
            if (this._summaryEngine) {
                this._summaryEngine.cancel();
                this.summaryProcessCleanup();
            }
        };
        SummaryViewController.prototype.onSummaryProcessComplete = function (summary) {
            for (var i = 0; i < this.model.snapshotSummaryCollection.length; i++) {
                if (this.model.snapshotSummaryCollection.getItem(i).id === summary.id) {
                    this.model.snapshotSummaryCollection.replace(i, summary);
                    break;
                }
            }
            this.processNextSnapshotSummary();
        };
        SummaryViewController.prototype.onSummaryProcessError = function (error) {
            /// need to report the error!
            this.summaryProcessCleanup();
        };
        SummaryViewController.prototype.onSummaryProcessProgress = function (progress) {
            // UI during analysis would be nice :)
        };
        SummaryViewController.prototype.summaryProcessCleanup = function () {
            this._summaryEngine = null;
            this._summaryAgents = null;
            this._pendingSnapshots = [];
            this.model.restoringSnapshots = false;
            // If we had snapshots to restore, we're now done loading the view
            //
            // !! NOTE: The order of code markers is important for automation. !!
            // We need to make sure ViewLoad fires after RestoringSnapshots
            // (fired by setting restoringSnapshots above).
            //
            MemoryProfiler.Common.MemoryProfilerViewHost.endCodeMarker(MemoryProfiler.Common.CodeMarkerValues.perfMP_ViewLoadStart);
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logEndLoadSnapshots();
        };
        return SummaryViewController;
    }());
    MemoryProfiler.SummaryViewController = SummaryViewController;
    var SummaryViewModel = (function (_super) {
        __extends(SummaryViewModel, _super);
        function SummaryViewModel() {
            _super.call(this);
            this._warningMessage = "";
            this._restoringSnapshots = false;
            this._snapshotDisplayType = MemoryProfiler.SnapshotDisplayType.managed;
            this._snapshotSummaryCollection = new MemoryProfiler.Common.Controls.ObservableCollection();
            // Note: In the future, we may have per-view default settings. For now, log the defaults as coming from the corresponding views.
            this.LogSelectSnapshotViewCommand(this.snapshotDisplayType, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Default, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
        }
        Object.defineProperty(SummaryViewModel.prototype, "snapshotSummaryCollection", {
            get: function () { return this._snapshotSummaryCollection; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SummaryViewModel.prototype, "warningMessage", {
            get: function () { return this._warningMessage; },
            set: function (v) {
                if (this._warningMessage !== v) {
                    this._warningMessage = v;
                    this.raisePropertyChanged("warningMessage");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SummaryViewModel.prototype, "snapshotDisplayType", {
            get: function () { return this._snapshotDisplayType; },
            set: function (v) {
                if (this._snapshotDisplayType !== v) {
                    this._snapshotDisplayType = v;
                    this.LogSelectSnapshotViewCommand(v, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Control, MemoryProfiler.Common.FeedbackCommandSourceNames.SummaryView);
                    this.raisePropertyChanged("snapshotDisplayType");
                }
            },
            enumerable: true,
            configurable: true
        });
        SummaryViewModel.prototype.LogSelectSnapshotViewCommand = function (v, invokeMethodName, commandSourceName) {
            var feedbackCommandName;
            if (v === MemoryProfiler.SnapshotDisplayType.managed) {
                feedbackCommandName = MemoryProfiler.Common.FeedbackCommandNames.SelectManagedHeapSnapshotView;
            }
            else {
                feedbackCommandName = MemoryProfiler.Common.FeedbackCommandNames.SelectNativeHeapSnapshotView;
            }
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(feedbackCommandName, invokeMethodName, commandSourceName);
        };
        Object.defineProperty(SummaryViewModel.prototype, "restoringSnapshots", {
            get: function () {
                return this._restoringSnapshots;
            },
            set: function (v) {
                if (this._restoringSnapshots !== v) {
                    this._restoringSnapshots = v;
                    this.raisePropertyChanged("restoringSnapshots");
                    if (this._restoringSnapshots) {
                        MemoryProfiler.Common.MemoryProfilerViewHost.startCodeMarker(MemoryProfiler.Common.CodeMarkerValues.perfMP_SnapshotRestoreStart, MemoryProfiler.Common.CodeMarkerValues.perfMP_SnapshotRestoreEnd);
                    }
                    else {
                        MemoryProfiler.Common.MemoryProfilerViewHost.endCodeMarker(MemoryProfiler.Common.CodeMarkerValues.perfMP_SnapshotRestoreStart);
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        return SummaryViewModel;
    }(MemoryProfiler.Common.Controls.ObservableViewModel));
    MemoryProfiler.SummaryViewModel = SummaryViewModel;
    var SummaryView = (function (_super) {
        __extends(SummaryView, _super);
        function SummaryView(controller, model) {
            _super.call(this, "SummaryViewTemplate");
            this._controller = controller;
            this._model = model;
            this._snapshotTileViewModelCollection = [];
            this._model.registerPropertyChanged(this);
            this._model.snapshotSummaryCollection.registerCollectionChanged(this);
            this._tilesContainer = this.findElement("tilesContainer");
            this._warningSection = this.findElement("warningSection");
        }
        Object.defineProperty(SummaryView.prototype, "snapshotTileViewModelCollection", {
            get: function () {
                return this._snapshotTileViewModelCollection;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SummaryView.prototype, "tilesContainer", {
            get: function () {
                return this._tilesContainer;
            },
            enumerable: true,
            configurable: true
        });
        SummaryView.prototype.initializeToggleBar = function () {
            this._snapshotToggleBar = this.findElement("toggleTabSection");
            var toggle = new MemoryProfiler.SnapshotHeapTypeToggle(this._model);
            this._snapshotToggleBar.appendChild(toggle.rootElement);
        };
        SummaryView.prototype.onPropertyChanged = function (propertyName) {
            switch (propertyName) {
                case "warningMessage":
                    this.showWarningMessage(this._model.warningMessage);
                    break;
            }
        };
        SummaryView.prototype.onCollectionChanged = function (eventArgs) {
            switch (eventArgs.action) {
                case MemoryProfiler.Common.Controls.NotifyCollectionChangedAction.Add:
                    this.createTile(eventArgs.newItems[0]);
                    break;
                case MemoryProfiler.Common.Controls.NotifyCollectionChangedAction.Reset:
                    this.removeSnapshotTiles();
                    break;
                case MemoryProfiler.Common.Controls.NotifyCollectionChangedAction.Replace:
                    this.updateTile(eventArgs.newItems[0]);
                    break;
            }
        };
        SummaryView.prototype.updateTile = function (snapshotSummary) {
            for (var i = 0; i < this._snapshotTileViewModelCollection.length; i++) {
                if (this._snapshotTileViewModelCollection[i].summaryData.id === snapshotSummary.id) {
                    this._snapshotTileViewModelCollection[i].summaryData = snapshotSummary;
                    break;
                }
            }
        };
        SummaryView.prototype.createTile = function (snapshotSummary) {
            // Create the model and the view
            var model = new MemoryProfiler.SnapshotTileViewModel(snapshotSummary, this._model.snapshotSummaryCollection);
            var newTile = new MemoryProfiler.SnapshotTileView(this._controller, model);
            this._model.snapshotSummaryCollection.registerCollectionChanged(newTile);
            this._snapshotTileViewModelCollection.push(model);
            this._tilesContainer.appendChild(newTile.rootElement);
            newTile.rootElement.focus();
        };
        SummaryView.prototype.removeSnapshotTiles = function () {
            while (this._tilesContainer.hasChildNodes()) {
                this._tilesContainer.removeChild(this._tilesContainer.firstChild);
            }
            this._snapshotTileViewModelCollection = [];
        };
        SummaryView.prototype.toggleProgress = function (show) {
            if (this._snapshotProgress && this._snapshotError) {
                if (show) {
                    this._snapshotLabel.style.display = "none";
                    this._snapshotIcon.style.display = "none";
                    this._snapshotProgress.style.display = "block";
                    this._snapshotError.style.display = "none";
                }
                else {
                    this._snapshotLabel.style.display = "";
                    this._snapshotIcon.style.display = "";
                    this._snapshotProgress.style.display = "none";
                }
            }
        };
        SummaryView.prototype.showSnapshotError = function (error) {
            if (this._snapshotErrorMsg && this._snapshotError) {
                if (error) {
                    // Show the message
                    this._snapshotErrorMsg.innerText = MemoryProfiler.Common.ErrorFormatter.format(error);
                    this._snapshotError.style.display = "block";
                }
                else {
                    // Hide the message
                    this._snapshotErrorMsg.innerText = "";
                    this._snapshotError.style.display = "none";
                }
            }
        };
        SummaryView.prototype.showWarningMessage = function (warning) {
            if (!this._warningSection) {
                return;
            }
            if (warning) {
                this._warningSection.innerHTML = warning;
                this._warningSection.style.display = "-ms-grid";
            }
            else {
                this._warningSection.innerHTML = "";
                this._warningSection.style.display = "none";
            }
        };
        return SummaryView;
    }(MemoryProfiler.Common.Controls.TemplateControl));
    MemoryProfiler.SummaryView = SummaryView;
})(MemoryProfiler || (MemoryProfiler = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
//--------
// External CommonMerged references.  These are included explicitly in the csproj
// as the CommonMerged.d.ts is generated at build-time.
// If we reference them here, TSC 1.8.10 includes the source in the merged JS file
// which is not what we want.
//--------
// <reference path="../../Common/Controls/templateControl.ts" />
//--------
/// <reference path="SummaryView.ts" />
var MemoryProfiler;
(function (MemoryProfiler) {
    "use strict";
    (function (SnapshotDisplayType) {
        SnapshotDisplayType[SnapshotDisplayType["managed"] = 0] = "managed";
        SnapshotDisplayType[SnapshotDisplayType["native"] = 1] = "native";
    })(MemoryProfiler.SnapshotDisplayType || (MemoryProfiler.SnapshotDisplayType = {}));
    var SnapshotDisplayType = MemoryProfiler.SnapshotDisplayType;
    var SnapshotHeapTypeToggle = (function (_super) {
        __extends(SnapshotHeapTypeToggle, _super);
        function SnapshotHeapTypeToggle(viewModel) {
            _super.call(this, "SnapshotHeapTypeToggleTemplate");
            this._summaryViewModel = viewModel;
            this._summaryViewModel.registerPropertyChanged(this);
            this._managedHeapButton = this.findElement("snapshotToggleTabManagedButton");
            this._nativeHeapButton = this.findElement("snapshotToggleTabdNativeButton");
            this.findElement("snapshotToggleTabLabel").innerText = Microsoft.Plugin.Resources.getString("SnapshotToggleTabLabel");
            ;
            this._managedHeapButton.innerHTML = Microsoft.Plugin.Resources.getString("SnapshotToggleTabManagedButton");
            this._nativeHeapButton.innerText = Microsoft.Plugin.Resources.getString("SnapshotToggleTabNativeButton");
            this._managedHeapButton.onclick = this.setManagedHeapToggleButtonSelected.bind(this);
            this._nativeHeapButton.onclick = this.setNativeHeapToggleButtonSelected.bind(this);
            var toggleButtons = this.findElementsByClassName("toggleTabButtonContainer");
            for (var buttomIndex = 0; buttomIndex < toggleButtons.length; buttomIndex++) {
                var buttonElement = toggleButtons[buttomIndex];
                buttonElement.onkeydown = this.onButtonElementKeyDown.bind(buttonElement);
            }
            this.updateUI();
        }
        SnapshotHeapTypeToggle.prototype.onButtonElementKeyDown = function (e) {
            if ((e.keyCode === MemoryProfiler.Common.KeyCodes.ENTER || e.keyCode === MemoryProfiler.Common.KeyCodes.SPACE) && !e.ctrlKey && !e.altKey && !e.shiftKey) {
                e.srcElement.click();
            }
        };
        SnapshotHeapTypeToggle.prototype.onPropertyChanged = function (propertyName) {
            switch (propertyName) {
                case "snapshotDisplayType":
                    this.updateUI();
                    break;
            }
        };
        SnapshotHeapTypeToggle.prototype.updateUI = function () {
            var isManagedSelected = this._summaryViewModel.snapshotDisplayType === SnapshotDisplayType.managed;
            if (isManagedSelected) {
                this._managedHeapButton.classList.add("toggleTabSelectedButtonOutline");
                this._nativeHeapButton.classList.remove("toggleTabSelectedButtonOutline");
            }
            else if (this._summaryViewModel.snapshotDisplayType === SnapshotDisplayType.native) {
                this._nativeHeapButton.classList.add("toggleTabSelectedButtonOutline");
                this._managedHeapButton.classList.remove("toggleTabSelectedButtonOutline");
            }
            this._nativeHeapButton.setAttribute("aria-checked", isManagedSelected ? "false" : "true");
            this._managedHeapButton.setAttribute("aria-checked", isManagedSelected ? "true" : "false");
        };
        SnapshotHeapTypeToggle.prototype.setManagedHeapToggleButtonSelected = function () {
            this._summaryViewModel.snapshotDisplayType = SnapshotDisplayType.managed;
        };
        SnapshotHeapTypeToggle.prototype.setNativeHeapToggleButtonSelected = function () {
            this._summaryViewModel.snapshotDisplayType = SnapshotDisplayType.native;
        };
        return SnapshotHeapTypeToggle;
    }(MemoryProfiler.Common.Controls.TemplateControl));
    MemoryProfiler.SnapshotHeapTypeToggle = SnapshotHeapTypeToggle;
})(MemoryProfiler || (MemoryProfiler = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
//--------
// External CommonMerged references.  These are included explicitly in the csproj
// as the CommonMerged.d.ts is generated at build-time.
// If we reference them here, TSC 1.8.10 includes the source in the merged JS file
// which is not what we want.
//--------
// <reference path="../../Common/Extensions/Session.ts" />
// <reference path="../../Common/controls/control.ts" />
// <reference path="../../Common/controls/componentModel.ts" />
// <reference path="../../Common/Profiler/MemoryProfilerViewHost.ts" />
//--------
/// <reference path="SummaryView.ts" />
var MemoryProfiler;
(function (MemoryProfiler) {
    "use strict";
    var SummaryViewHost = (function (_super) {
        __extends(SummaryViewHost, _super);
        function SummaryViewHost() {
            _super.call(this);
        }
        SummaryViewHost.prototype.initializeView = function (sessionInfo) {
            this.summaryViewController = new MemoryProfiler.SummaryViewController(sessionInfo);
            document.getElementById('mainContainer').appendChild(this.summaryViewController.view.rootElement);
        };
        return SummaryViewHost;
    }(MemoryProfiler.Common.MemoryProfilerViewHostBase));
    MemoryProfiler.SummaryViewHost = SummaryViewHost;
    MemoryProfiler.SummaryViewHostInstance = new SummaryViewHost();
})(MemoryProfiler || (MemoryProfiler = {}));
MemoryProfiler.SummaryViewHostInstance.loadView();
//# sourceMappingURL=SummaryViewMerged.js.map
// SIG // Begin signature block
// SIG // MIIkDQYJKoZIhvcNAQcCoIIj/jCCI/oCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // FcsqmHPVSnfa1ndvEvke8xrzC4VATW41BotKovL9ETeg
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFdIwghXOAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggcAwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIM/dutCmH7wkWBsp8zxs8ZrPBi5Mvz+jt3Nq6YYl
// SIG // 8QsfMFQGCisGAQQBgjcCAQwxRjBEoCqAKABTAHUAbQBt
// SIG // AGEAcgB5AFYAaQBlAHcATQBlAHIAZwBlAGQALgBqAHOh
// SIG // FoAUaHR0cDovL21pY3Jvc29mdC5jb20wDQYJKoZIhvcN
// SIG // AQEBBQAEggEAEvjZdSLtKhMZilEcGmxyiRQktisTzZ6h
// SIG // F5KwLL8Dlw7EUITFFZt9N8ld0VyZex1Zen/U1FtW6SR2
// SIG // HY8fK0ePhX8DEzypqhgkMkrY8yrI2EuQaJnIxJfJAdoL
// SIG // hWtbjzJkuWJjBEmO4LdWbJJVj9Zm8K7IxI/o3gpZEvrv
// SIG // i9J9JiVR50RnHt3WVLF4kbzKeo6tUUF8u/+XzsS4UAEk
// SIG // 9/+TEi5Vd8+c5vdQrCPn8RBzujweUFKTe9p1I1bFV/Tg
// SIG // 6UGxzWowqb4dBoF0ZlFRzgBWG/zvIOMc5fBAPfDH+XqV
// SIG // hwLEOMJa+YU6EIG4SomSrcqVHUvF32RXX00s0qDwsZj9
// SIG // o6GCE0owghNGBgorBgEEAYI3AwMBMYITNjCCEzIGCSqG
// SIG // SIb3DQEHAqCCEyMwghMfAgEDMQ8wDQYJYIZIAWUDBAIB
// SIG // BQAwggE9BgsqhkiG9w0BCRABBKCCASwEggEoMIIBJAIB
// SIG // AQYKKwYBBAGEWQoDATAxMA0GCWCGSAFlAwQCAQUABCD2
// SIG // aHDo2K4wdASvumAHcc187z7SMjUNiBu2jHalos5YsQIG
// SIG // WIurMinKGBMyMDE3MDIwOTAzNDM0MC4xOTdaMAcCAQGA
// SIG // AgH0oIG5pIG2MIGzMQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0w
// SIG // CwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERT
// SIG // RSBFU046RjUyOC0zNzc3LThBNzYxJTAjBgNVBAMTHE1p
// SIG // Y3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Wggg7NMIIG
// SIG // cTCCBFmgAwIBAgIKYQmBKgAAAAAAAjANBgkqhkiG9w0B
// SIG // AQsFADCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEyMDAGA1UE
// SIG // AxMpTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0
// SIG // aG9yaXR5IDIwMTAwHhcNMTAwNzAxMjEzNjU1WhcNMjUw
// SIG // NzAxMjE0NjU1WjB8MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYw
// SIG // JAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Eg
// SIG // MjAxMDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAKkdDbx3EYo6IOz8E5f1+n9plGt0VBDVpQoAgoX7
// SIG // 7XxoSyxfxcPlYcJ2tz5mK1vwFVMnBDEfQRsalR3OCROO
// SIG // fGEwWbEwRA/xYIiEVEMM1024OAizQt2TrNZzMFcmgqNF
// SIG // DdDq9UeBzb8kYDJYYEbyWEeGMoQedGFnkV+BVLHPk0yS
// SIG // wcSmXdFhE24oxhr5hoC732H8RsEnHSRnEnIaIYqvS2SJ
// SIG // UGKxXf13Hz3wV3WsvYpCTUBR0Q+cBj5nf/VmwAOWRH7v
// SIG // 0Ev9buWayrGo8noqCjHw2k4GkbaICDXoeByw6ZnNPOcv
// SIG // RLqn9NxkvaQBwSAJk3jN/LzAyURdXhacAQVPIk0CAwEA
// SIG // AaOCAeYwggHiMBAGCSsGAQQBgjcVAQQDAgEAMB0GA1Ud
// SIG // DgQWBBTVYzpcijGQ80N7fEYbxTNoWoVtVTAZBgkrBgEE
// SIG // AYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8EBAMCAYYw
// SIG // DwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAWgBTV9lbL
// SIG // j+iiXGJo0T2UkFvXzpoYxDBWBgNVHR8ETzBNMEugSaBH
// SIG // hkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9NaWNSb29DZXJBdXRfMjAxMC0wNi0y
// SIG // My5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsGAQUFBzAC
// SIG // hj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2Nl
// SIG // cnRzL01pY1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNydDCB
// SIG // oAYDVR0gAQH/BIGVMIGSMIGPBgkrBgEEAYI3LgMwgYEw
// SIG // PQYIKwYBBQUHAgEWMWh0dHA6Ly93d3cubWljcm9zb2Z0
// SIG // LmNvbS9QS0kvZG9jcy9DUFMvZGVmYXVsdC5odG0wQAYI
// SIG // KwYBBQUHAgIwNB4yIB0ATABlAGcAYQBsAF8AUABvAGwA
// SIG // aQBjAHkAXwBTAHQAYQB0AGUAbQBlAG4AdAAuIB0wDQYJ
// SIG // KoZIhvcNAQELBQADggIBAAfmiFEN4sbgmD+BcQM9naOh
// SIG // IW+z66bM9TG+zwXiqf76V20ZMLPCxWbJat/15/B4vceo
// SIG // niXj+bzta1RXCCtRgkQS+7lTjMz0YBKKdsxAQEGb3FwX
// SIG // /1z5Xhc1mCRWS3TvQhDIr79/xn/yN31aPxzymXlKkVIA
// SIG // rzgPF/UveYFl2am1a+THzvbKegBvSzBEJCI8z+0DpZaP
// SIG // WSm8tv0E4XCfMkon/VWvL/625Y4zu2JfmttXQOnxzplm
// SIG // kIz/amJ/3cVKC5Em4jnsGUpxY517IW3DnKOiPPp/fZZq
// SIG // kHimbdLhnPkd/DjYlPTGpQqWhqS9nhquBEKDuLWAmyI4
// SIG // ILUl5WTs9/S/fmNZJQ96LjlXdqJxqgaKD4kWumGnEcua
// SIG // 2A5HmoDF0M2n0O99g/DhO3EJ3110mCIIYdqwUB5vvfHh
// SIG // AN/nMQekkzr3ZUd46PioSKv33nJ+YWtvd6mBy6cJrDm7
// SIG // 7MbL2IK0cs0d9LiFAR6A+xuJKlQ5slvayA1VmXqHczsI
// SIG // 5pgt6o3gMy4SKfXAL1QnIffIrE7aKLixqduWsqdCosnP
// SIG // GUFN4Ib5KpqjEWYw07t0MkvfY3v1mYovG8chr1m1rtxE
// SIG // PJdQcdeh0sVV42neV8HR3jDA/czmTfsNv11P6Z0eGTgv
// SIG // vM9YBS7vDaBQNdrvCScc1bN+NR4Iuto229Nfj950iEkS
// SIG // MIIE2jCCA8KgAwIBAgITMwAAALCG6ZIgCl3q+AAAAAAA
// SIG // sDANBgkqhkiG9w0BAQsFADB8MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFt
// SIG // cCBQQ0EgMjAxMDAeFw0xNjA5MDcxNzU2NTZaFw0xODA5
// SIG // MDcxNzU2NTZaMIGzMQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0w
// SIG // CwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERT
// SIG // RSBFU046RjUyOC0zNzc3LThBNzYxJTAjBgNVBAMTHE1p
// SIG // Y3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2UwggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDw5fCNlFmp
// SIG // mtdsCQd3FCFZXbc9eLg1rfUwMf/O4f/W6RrJg5gj+5AQ
// SIG // wZLsOrxQbJC9XPFrrUyi9WGlh+EprKM8Et9/xACCzr20
// SIG // Cl/LuduatxktWu0HAK1U/TOs9vgSJEokZ1fauEuhrA+A
// SIG // +Tm9IA21p8QsS/GhVubyLye5JsEzJdkrDDByUIRrkmqV
// SIG // jPL6CE24LiTVQ9Pc6/N0aoizybRg3MllrV8J5RFqFDTB
// SIG // 5FcGEkbmoL2EWiRCQ/a89CxVmVqNs4imqhKUIr6GtUqJ
// SIG // jKpHsKDFHxuPnPBibVSdMtOpxJtT6blyO78Xnq9YXJ3G
// SIG // K1Ahu9iWzDbvjaZz2a27Q3AVAgMBAAGjggEbMIIBFzAd
// SIG // BgNVHQ4EFgQU/KgHUtnvKf6YQzwVXHRet39z4K8wHwYD
// SIG // VR0jBBgwFoAU1WM6XIoxkPNDe3xGG8UzaFqFbVUwVgYD
// SIG // VR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljVGltU3Rh
// SIG // UENBXzIwMTAtMDctMDEuY3JsMFoGCCsGAQUFBwEBBE4w
// SIG // TDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNUaW1TdGFQQ0FfMjAx
// SIG // MC0wNy0wMS5jcnQwDAYDVR0TAQH/BAIwADATBgNVHSUE
// SIG // DDAKBggrBgEFBQcDCDANBgkqhkiG9w0BAQsFAAOCAQEA
// SIG // kv2A93W9ZZA+F83VFYPFjgKRO6xOfWDvjzkGk5DjD6pF
// SIG // PYk/Av3sb7hQkAlshNI3IZmxwYZ2HeQNxo7/GOCi+ka1
// SIG // hXd0bk4MREXQvNK2BH5wSw/WqwdpVkp2ZOj5qkejo4bc
// SIG // 9M9EuEkQW2eP0dp5rjrdh1MG6I9q/H/X5KOGRRUNkWIi
// SIG // OpBK49hoAUnJLQ5reGwRAvSPTRFgc6gDIQ2X4w9ydbv9
// SIG // 6A646/wgQZ2Ok/3FM3M+OXq9ajQeOUdiEbUc71f0c4Nx
// SIG // n6gUZb7kA45NbcQBMxt+V+yh8xyXqTin9Kg6OfmJNfxd
// SIG // oyKuCr2NDKsxEm7pvWEW7PQZOiSFYl+psqGCA3YwggJe
// SIG // AgEBMIHjoYG5pIG2MIGzMQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVy
// SIG // IERTRSBFU046RjUyOC0zNzc3LThBNzYxJTAjBgNVBAMT
// SIG // HE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2WiJQoB
// SIG // ATAJBgUrDgMCGgUAAxUAvIT7nVsS2sc2hTuIZp6jFhjV
// SIG // zByggcIwgb+kgbwwgbkxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // TlRTIEVTTjo1N0Y2LUMxRTAtNTU0QzErMCkGA1UEAxMi
// SIG // TWljcm9zb2Z0IFRpbWUgU291cmNlIE1hc3RlciBDbG9j
// SIG // azANBgkqhkiG9w0BAQUFAAIFANxGNIgwIhgPMjAxNzAy
// SIG // MDkwMDIxMjhaGA8yMDE3MDIxMDAwMjEyOFowdDA6Bgor
// SIG // BgEEAYRZCgQBMSwwKjAKAgUA3EY0iAIBADAHAgEAAgIB
// SIG // xjAHAgEAAgIbMDAKAgUA3EeGCAIBADA2BgorBgEEAYRZ
// SIG // CgQCMSgwJjAMBgorBgEEAYRZCgMBoAowCAIBAAIDFuNg
// SIG // oQowCAIBAAIDB6EgMA0GCSqGSIb3DQEBBQUAA4IBAQAY
// SIG // jBhhG6oLiiNv6mZogqxukoDvyR7/qklj9SnQgR3cq3Xa
// SIG // BEnK5RUjqFylWQ4hdcz+VtdfPhwDB95pqsLxwkSuqt7P
// SIG // P57+qMwQxp7GzGkYz5Yww9QXfepNIlQQYkQV+TgoJ721
// SIG // V0d/lIvcg+eSIqN0BciXCIEhMfvDXqtipg31ftSdx4yO
// SIG // 02s4eMTVhaIzz4PdSH0a/6iS3fIdXsPDyqjJZ3ICGYK5
// SIG // lV3irizgVWli51yKkzN89NnIw5U1fPhscCNu+D8WPH+v
// SIG // Xgq96Qe3BuyvdwiJE7cgbNafH2P8nJUoXxGb/l/Xn/Hg
// SIG // Gw9po4M5h/GyFY32z1CPVM+mQ3HLA+dnMYIC9TCCAvEC
// SIG // AQEwgZMwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UE
// SIG // AxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAC
// SIG // EzMAAACwhumSIApd6vgAAAAAALAwDQYJYIZIAWUDBAIB
// SIG // BQCgggEyMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRAB
// SIG // BDAvBgkqhkiG9w0BCQQxIgQgqJEYfn0nK+FE1oK/l8Wd
// SIG // wkcsAOlkLUVpvfrRKDgsgSowgeIGCyqGSIb3DQEJEAIM
// SIG // MYHSMIHPMIHMMIGxBBS8hPudWxLaxzaFO4hmnqMWGNXM
// SIG // HDCBmDCBgKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQI
// SIG // EwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4w
// SIG // HAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAk
// SIG // BgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAy
// SIG // MDEwAhMzAAAAsIbpkiAKXer4AAAAAACwMBYEFFHUlpu9
// SIG // yIf7hQbEOljWLP8rKJ7cMA0GCSqGSIb3DQEBCwUABIIB
// SIG // ANKRtb0uIQb9POprtnEES30Tyt9mJLieAw//OKm9DG4I
// SIG // 1dbmFAD9jxeib89gvclPGXvchVvm8IPxZLwJrspQdCZG
// SIG // jn2gidwZP7bgMqt0vpNW/LQI6LglTJO4KztGd/z0Vl3k
// SIG // ukUrmvJHrMNZLnhxptlO9pq/VrsZcduHya2FN4NuGxq7
// SIG // 8GRK9xTgMtV4L323wYOAIbyA/wGpyWE88mlRfI8xPP7F
// SIG // Zc+7irkwDzOKC+PFAJEE0j15OgCJSHodPphn+zi0/e3W
// SIG // os3beaIKNJRvCi/LN2wyFAp4tOmoGo5HGdXfxJNp4NKw
// SIG // kwEZx9z6egiLZ94VZJgU2wN4ax4VWy1XuRs=
// SIG // End signature block
